<?php
session_start();
include('db_connection.php');  // اتصال به دیتابیس

// فرض بر این است که کاربر وارد حساب خود شده است و user_id او در سشن ذخیره شده است
$user_id = $_SESSION['user_id'];  // شناسه کاربر (باید به صورت صحیح از سشن خوانده شود)

// گرفتن اطلاعات محصول از فرم
$product_id = $_POST['product_id'];
$quantity = $_POST['quantity'];

// بررسی اینکه آیا محصول قبلاً در سبد خرید موجود است یا نه
$sql = "SELECT * FROM cart WHERE user_id = ? AND product_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $user_id, $product_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // اگر محصول قبلاً در سبد خرید موجود است، تعداد آن را به روز رسانی می‌کنیم
    $row = $result->fetch_assoc();
    $new_quantity = $row['quantity'] + $quantity;

    $update_sql = "UPDATE cart SET quantity = ? WHERE user_id = ? AND product_id = ?";
    $update_stmt = $conn->prepare($update_sql);
    $update_stmt->bind_param("iii", $new_quantity, $user_id, $product_id);
    $update_stmt->execute();
} else {
    // اگر محصول در سبد خرید وجود ندارد، آن را اضافه می‌کنیم
    $insert_sql = "INSERT INTO cart (user_id, product_id, quantity) VALUES (?, ?, ?)";
    $insert_stmt = $conn->prepare($insert_sql);
    $insert_stmt->bind_param("iii", $user_id, $product_id, $quantity);
    $insert_stmt->execute();
}

echo "محصول به سبد خرید شما افزوده شد.";
?>
